### 概述

**UDP协议**

UDP协议：用户数据报协议（User Datagram Protocol）,是OSI参考模型中的传输层协议，它与TCP协议一样用于处理数据包，是一种无连接的传输层协议。UDP有不断提供数据包分组、组装和不能对数据包进行排序，也就是说，当报文发送之后无法得知是否安全到达，是一种提供面向事务简单不可靠信息传送服务。


![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/68196e99e6c0a.png)

---
### 准备

 **安装要求**

* 中科时代出厂的工智机；

* Device Manager组件管理器；

* 个人电脑安装中科时代IDE MetaFacture软件；

* 个人电脑需要联网


**SF4200-sitcpudp组件安装**

1.打开Device Manager 0.0.1.9组件管理器
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/68196ec37c2da.png)

2.选择左下角的“安装ACP服务”
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/68196ee0c0a3f.png)

3.设定IP、用户名和密码，选择“在线安装”。

（本例为192.168.110.155，用户名：sinsegye，密码：1）
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/68196eed4a9a0.png)


4.安装完成后，点击“扫描”，出现目标工智机后，双击进入设备管理页面。
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/68196ef7ed3da.png)


5.在设备管理页面，选择“安装RTE插件服务”
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/68196f0028aee.png)

6.输入用户名sinsegye，密码1，点击“在线安装”
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/68196f09cfb1e.png)

7.安装完成后，选择“组件”—“组件管理”
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/68196f1267323.png)

8.点击“浏览”，可以在线浏览工智机发布的组件。
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/68196f1a04bff.png)

9.选择“SF4200-sitcpudp”组件，点击“安装”
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/68196f21b2dda.png)

传输完成，确认安装插件。
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/68196f2bba0e8.png)

安装完成，重启生效。
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/68196f35c84a7.png)

10.安装完成后，在本地可以显示已安装的SF4200-sitcpudp组件。
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/68196f3d0d7d2.png)

 **组件更新和卸载**

打开Device Manager，进入工智机设备管理页面—“组件”—“组件管理”，选择需要更新或者卸载的组件，点击“卸载”或“更新”
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/68196f4c11c4d.png)

---
### 示例

**UDP Socket建立**

1. 打开中科时代IDE MetaFacture，选择“新建工程”

![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/68196f6617d15.png)
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/68196f70c9267.png)

2.选择标准工程，并命名UDP
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/68196f7b41a26.png)

3.选择中科时代Sinsegye设备，选择PLC编程语言(本例为ST语言)
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/68196f82c6584.png)
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/68196f8b64f9a.png)

4.选择“库管理器”—“添加库”—选择“SF4200\_TcpUdp”—确定
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/68196f966168b.png)
SF4200\_TcpUdp添加到库管理器中。
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/68196fa09b19a.png)

5.使用“输入助手”在PLC\_PRG中声明UPD\_Peer变量。鼠标右键选择“输入助手”。
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/68196fa8e6713.png)

选择“结构体类型”—“MetaCore\_TcpUdp”—“FB\_SocketUdpCreate”
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/68196fb65882c.png)

功能块声明完成。
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/68196fc17fd59.png)

6.使用“输入助手”在程序中插入声明的UDP\_Peer功能块。鼠标右键选择“输入助手”
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/68196fcc05c80.png)

选择“实例调用”—“Udp\_Peer”
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/68196fd3a41d6.png)

Udp\_Peer通过输入助手自动插入到PLC程序中。
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/68196fe01224d.png)

7.声明三个变量，用于设定Udp\_Peer功能块的本机IP地址、端口和启动建立信号。
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/68196feadc509.png)

**UDP Send功能**

1.鼠标右键使用“输入助手”声明Udp\_Send功能块和调用Udp\_Send功能块。
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/68196ffc66b20.png)

2.新建以下三个变量，并且把Udp\_Peer的输出信号hSocket和新建的三个变量传入到Udp\_Send的输入设定中。



| 变量名称       | 类型     | 设定例               | 意义         |
| ---------- | ------ | ----------------- | ---------- |
| RemoteAddr | STRING | ‘192.168.110.135’ | UDP连接的IP地址 |
| RemotePort | UDINT  | 9999              | UDP连接的端口   |
| bSend      | BOOL   | FALSE             | 发送信号       |

![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/6819700e71cb3.png)

3.新建SendData变量，设定初始值为‘This is a teast’。将SendData指针和字节大小传入到Udp\_Send的输入设定中
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/6819701876b99.png)

4.选择“Device”—输入工智机IP地址连接工智机。本例为192.168.110.155.
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/681970209f4f4.png)

5.点击“登录”
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/6819702a42048.png)

6.登陆后，点击“运行”程序
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/68197032e9489.png)

7.使用个人电脑打开调试工具Socket Tool
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/68197044b6d16.png)

8.选择“UDP Client”—“创建”
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/6819704f039d2.png)

10.设定工智机IP地址、工智机端口，以及本机端口，点击确定。
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/681970587dd97.png)

11.将变量bCreat置True，建立UDP Socket。
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/6819706322369.png)

12\. 变量bSend置True，发送数据’This is a test’
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/6819706eea8df.png)

13.查看Socket Tool，收到This is a test数据。
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/6819707c670be.png)

**UDP Receive功能**

1.鼠标右键使用“输入助手”声明Udp\_Receive功能块和调用Udp\_Receive功能块。
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/68197089bacae.png)

2.新建以下四个变量，并且把Udp\_Peer的输出信号hSocket和新建的四个变量传入到Udp\_Receive的功能块中。

| 变量名称         | 类型     | 意义          |
| ------------ | ------ | ----------- |
| bReceive     | BOOL   | UDP接收数据启动变量 |
| ReceiveAddr  | STRING | 发送数据端的IP地址  |
| ReceivePort  | UDINT  | 发送数据的端口     |
| ReceiveBytes | UDINT  | 数据大小        |

![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/68197093c292f.png)


3.新建ReceiveData变量，将ReceiveData指针和字节大小传入到Udp\_Receive的输入设定中.
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/681970a391abc.png)

4.选择“Device”—输入工智机IP地址连接工智机。本例为192.168.110.155.
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/681970b24060f.png)

5.点击“登录”
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/681970bc8954b.png)

6.登陆后，点击“运行”程序
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/681970c5eae6a.png)

7.使用个人电脑打开调试工具Socket Tool
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/681970cfc4e04.png)

8.选择“UDP Client”—“创建”
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/681970d915c65.png)

10.设定工智机IP地址、工智机端口，以及本机端口，点击确定。
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/681970e1dc8dd.png)

11.将变量bCreat置True，建立UDP Socket。
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/681970eeabfe6.png)

12\. 变量bReceive置True，使用Socket Tool发送数据‘ABCdef1234567890’
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/681970ff392a0.png)
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/681970fc49d98.png)

13.查看PLC程序中的ReceiveData，收到数据。
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/6819711f9d696.png)

**UDP Socket close关闭**

1.鼠标右键使用“输入助手”声明Udp\_Close功能块和调用Udp\_Close功能块。
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/681971305367b.png)

2声明执行关闭的变量bClose:BOOL,并将想要关闭的hSocket传入到输入接口中，本例为Udp\_Peer.hSocket。
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/68197138837ce.png)

3.选择“Device”—输入工智机IP地址连接工智机。本例为192.168.110.155.
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/68197142d4cbd.png)

5.点击“登录”
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/6819714b511dc.png)

6.登陆后，点击“运行”程序
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/6819715542359.png)

7.将bCreat置True，建立UDP Socket
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/6819716585776.png)

8. 将bClose置True，关闭UDP Socket
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/68197174599c8.png)
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/6819717d252a2.png)

---
### 功能介绍

 **功能块FB\_SocketUdpCreate**
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/681971871ac6f.png)

输入参数

| 参数名        | 类型     | 设定例               | 意义                |
| ---------- | ------ | ----------------- | ----------------- |
| sLocalHost | STRING | ‘192.168.110.155’ | 本机IP地址            |
| nLocalPort | UDINT  | 9000              | 本机端口              |
| bExecute   | BOOL   | TRUE              | 0→1时，建立UDP Socket |
| tTimeout   | TIME   | T#5S              | 超时时间，默认5s         |


输出参数

| 参数名     | 类型          | 意义          |
| ------- | ----------- | ----------- |
| bBusy   | BOOL        | 是否在执行中      |
| bError  | BOOL        | 是否发送错误      |
| nErrId  | UDINT       | 错误代码        |
| hSocket | ST\_HSOCKET | 建立的Socket信息 |


**功能块FB\_SocketUdpSendTo**
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/68197195f2086.png)



输入参数

| 参数名         | 类型              | 设定例                         | 意义         |
| ----------- | --------------- | --------------------------- | ---------- |
| hSocket     | ST\_HOCKET      | FB\_SocketUdpCreate.hSocket | 已建立的Socket |
| sRemoteHost | STRING          | '192.168.110.135'           | 接收数据到的IP地址 |
| nRemotePort | UDINT           | 9990                        | 接收数据到的端口   |
| cbLen       | UDINT           | SIZEOF(data)                | 发送数据的大小    |
| pSrc        | POINTER TO BYTE | ADR(data)                   | 发送数据的内容    |
| bExecute    | BOOL            | TRUE                        | 0→1时，发送数据  |
| tTimeout    | TIME            | T#5S                        | 超时时间，默认5s  |



输出参数

| 参数名    | 类型    | 意义     |
| ------ | ----- | ------ |
| bBusy  | BOOL  | 是否在执行中 |
| bError | BOOL  | 是否发送错误 |
| nErrId | UDINT | 错误代码   |





### **3.功能块FB\_SocketUdpReceiveFrom**
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/681971a955643.png)


输入参数

| 参数名      | 类型              | 设定例                         | 意义         |
| -------- | --------------- | --------------------------- | ---------- |
| hSocket  | ST\_HOCKET      | FB\_SocketUdpCreate.hSocket | 已建立的Socket |
| cbLen    | UDINT           | SIZEOF(Rdata)               | 接收存储数据的大小  |
| pDest    | POINTER TO BYTE | ADR(Rdata)                  | 接收存储数据的地址  |
| bExecute | BOOL            | TRUE                        | 0→1时，接收数据  |
| tTimeout | TIME            | T#5S                        | 超时时间，默认5s  |



输出参数

| 参数名         | 类型     | 意义           |
| ----------- | ------ | ------------ |
| bBusy       | BOOL   | 是否在执行中       |
| bError      | BOOL   | 是否发送错误       |
| nErrId      | UDINT  | 错误代码         |
| sRemoteHost | STRING | 远程发送数据方的IP地址 |
| nRemotePort | UDINT  | 远程发送数据方的端口   |
| nRecBytes   | UDINT  | 接收数据的大小      |



### **4.功能块FB\_SocketClose**
![](https://resource.helplook.net/docker_production/3648ne/article/IzFvGxDg/681971a1b37b4.png)


输入参数

| 参数名      | 类型         | 设定例                         | 意义            |
| -------- | ---------- | --------------------------- | ------------- |
| hSocket  | ST\_HOCKET | FB\_SocketUdpCreate.hSocket | 已建立的Socket    |
| bExecute | BOOL       | TRUE                        | 0→1时，关闭Socket |
| tTimeout | TIME       | T#5S                        | 超时时间，默认5s     |





输出参数

| 参数名    | 类型    | 意义     |
| ------ | ----- | ------ |
| bBusy  | BOOL  | 是否在执行中 |
| bError | BOOL  | 是否发送错误 |
| nErrId | UDINT | 错误代码   |